
#include "amg_msl_common.h"

#ifndef __RAY_TYPE
#define __RAY_TYPE

struct Ray {
    float3 msl_origin;
    float3 msl_direction;
};

Ray __Ray_ctor(float3 o, float3 d)
{
    Ray r;
    r.msl_origin = o;
    r.msl_direction = d;
    return r;
}

#endif // __RAY_TYPE

TextureCube <float4> __msl_Reflection_Environment_map_cubic_1_env_tex : environment_map_cubic <
    string description = "The cube texture from which the environment colors will be sampled";
    string NodeName = "Reflection_Environment_map_cubic_1";
    string UIMetaSLName = "env_tex";
    string parameter_source = "Reflection_Environment_map_cubic_1";
	string UIName = "msl_Reflection_Environment_map_cubic_1_env_tex";
	string ResourceName = "default_reflection_cubic.dds";
	string ResourceType = "Cube";
>;

SamplerState __msl_Reflection_Environment_map_cubic_1_env_tex_sampler {
	Filter = MIN_MAG_MIP_LINEAR;
	AddressU = Wrap;
	AddressV = Wrap;
	AddressW = Wrap;
};

float msl_Reflection_Environment_map_cubic_1_intensity : environment_map_cubic_intensity
<
    string UIName = "Intensity";
    float UIMin = 0.0f;
    float UIMax = 10.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string description = "How brightly the environment map will be reflected in the scene.";
    string NodeName = "Reflection_Environment_map_cubic_1";
    string UIMetaSLName = "intensity";
    string parameter_source = "Reflection_Environment_map_cubic_1";
> = 1.0f;

float4 __trace_environment(inout State state, Ray msl_ray)
{
    return __msl_Reflection_Environment_map_cubic_1_env_tex.Sample(__msl_Reflection_Environment_map_cubic_1_env_tex_sampler, msl_ray.msl_direction.xzy) * msl_Reflection_Environment_map_cubic_1_intensity;
}

float4 __trace_environment(Ray msl_ray, float msl_bias)
{
    float mip = __msl_Reflection_Environment_map_cubic_1_env_tex.CalculateLevelOfDetail(__msl_Reflection_Environment_map_cubic_1_env_tex_sampler, msl_ray.msl_direction.xzy);
    return __msl_Reflection_Environment_map_cubic_1_env_tex.SampleLevel(__msl_Reflection_Environment_map_cubic_1_env_tex_sampler, msl_ray.msl_direction.xzy, max(msl_bias, mip)) * msl_Reflection_Environment_map_cubic_1_intensity;
}

#define MAX_TRACE_ENVIRONMENT
